// ParallelPort.cpp
//

#include "stdafx.h"
#include "ParallelPort.h"

// NOTE: Edit the two following lines to reference the files on your system
#include "s:\Port95nt\API\dlportio.h"
#pragma comment (lib, "s:\\Port95nt\\API\\dlportio.lib")

//+++++++++++++++++++++++++++++++++++++++++++++

CParallelPort::CParallelPort(DWORD dwAddr/*=0x378*/, BYTE bData/*=0xff*/) :
	m_pfnDlPortReadPortUchar(NULL),
	m_pfnDlPortWritePortUchar(NULL),
	m_dwAddr(dwAddr),
	m_bData(bData),
	m_fInvertS7(true)
{ 
	m_hDll = LoadLibraryA("dlportio.dll");
	if(m_hDll)
	{
#define GETFCN(name)	m_pfn##name = GetProcAddress(m_hDll, #name);
		GETFCN(DlPortReadPortUchar)
		GETFCN(DlPortWritePortUchar)
	}

	Write();
}
CParallelPort::~CParallelPort()
{
	if(m_hDll)
		FreeLibrary(m_hDll);
}

typedef VOID (DLPORT_API *PFN_DlPortWritePortUchar)(ULONG Port, UCHAR Value);
void CParallelPort::Write()
{
	if(m_pfnDlPortWritePortUchar)
	{
		((PFN_DlPortWritePortUchar)m_pfnDlPortWritePortUchar)(m_dwAddr, m_bData);
	}
}

typedef UCHAR (DLPORT_API *PFN_DlPortReadPortUchar)(ULONG Port);
BYTE CParallelPort::Read()
{
	BYTE bVal = 0;
	if(m_pfnDlPortReadPortUchar)
	{
		bVal = ((PFN_DlPortReadPortUchar)m_pfnDlPortReadPortUchar)(m_dwAddr+1);
		if(m_fInvertS7)
		{
			if(ISBITSET(STATUS_7, bVal))
				CLRBIT(STATUS_7, bVal);
			else
				SETBIT(STATUS_7, bVal);
		}
	}
	return bVal;
}

void CParallelPort::SetBits(BYTE bMask)
{
//	ASSERT((bMask & m_bWriteMask) == bMask);
	SetValue(m_bData|bMask);
}

void CParallelPort::ClrBits(BYTE bMask)
{
//	ASSERT((bMask & m_bWriteMask) == bMask);
	SetValue(m_bData&~bMask);
}

void CParallelPort::Modify(BYTE bMask, BYTE bData)
{
	m_bData &= ~bMask;			// Clear the mask bits
	m_bData |= (bMask & bData);	// Set the masked data bits
	Write();
}

void CParallelPort::SetValue(BYTE bData)
{
	if(m_bData != bData)
	{
		m_bData = bData;
		Write();
	}
}
