#ifndef PARALLELPORT_H
#define PARALLELPORT_H

typedef enum
{
	STATUS_0 = 0x01,	// Unused
	STATUS_1 = 0x02,	// Unused
	STATUS_2 = 0x04,	// Unused
	STATUS_3 = 0x08,
	STATUS_4 = 0x10,
	STATUS_5 = 0x20,
	STATUS_6 = 0x40,
	STATUS_7 = 0x80,
} BIT_IN;

typedef enum
{
	DATA_0 = 0x01,
	DATA_1 = 0x02,
	DATA_2 = 0x04,
	DATA_3 = 0x08,
	DATA_4 = 0x10,
	DATA_5 = 0x20,
	DATA_6 = 0x40,
	DATA_7 = 0x80,
} BIT_OUT;
#define CLRBIT(bit, byte)	byte &= ~bit
#define SETBIT(bit, byte)	byte |= bit
#define ISBITSET(bit, byte)	(bit==(bit&byte))
#define ISBITCLR(bit, byte)	(0==(bit&byte))

class CParallelPort 
{
public:
	CParallelPort(DWORD dwAddr=0x378, BYTE bData=0xff);
	~CParallelPort();

	void InvertS7(bool fInvert)	{m_fInvertS7 = fInvert;}

	void Write();
	BYTE Read();

	void SetBits(BYTE bMask);
	void ClrBits(BYTE bMask);
	void SetValue(BYTE bData);
	void Modify(BYTE bMask, BYTE bData);

protected:
	BYTE m_bWriteMask;
	DWORD m_dwAddr;
	BYTE m_bData;
	bool m_fInvertS7;

	HMODULE m_hDll;
	FARPROC m_pfnDlPortReadPortUchar;
	FARPROC m_pfnDlPortWritePortUchar;
};

#endif //PARALLELPORT_H
